-- Macro Scripts File
-- Created:  Jan 12 2005
-- Author:   Michael Russo
-- Macro Scripts for Asset Tracking System
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript AssetTrackingSystemToggle
	category:~ASSETTRACKINGSYSTEMTOGGLE_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMTOGGLE_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMTOGGLE_BUTTONTEXT~ 
(
	On Execute Do     
	(
		Try (
			if ATSOps != undefined do ATSOps.visible = true 
		)
		Catch() 
	)

	on closeDialogs do
	(
		Try (
			if ATSOps != undefined do ATSOps.visible = false 
		)
		Catch() 
	)

	on isChecked Do
	(
		local result = true
		if ATSOps == undefined then
		(
			result = false
		)
		else
		(
			result = ATSOps.visible
		)
		result
	)

)
macroScript AssetTrackingSystemShow
	category:~ASSETTRACKINGSYSTEMSHOW_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMSHOW_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMSHOW_BUTTONTEXT~ 
(
	On Execute Do     
	(
		Try (
			if ATSOps != undefined do ATSOps.visible = true 
		)
		Catch() 
	)

)

macroScript AssetTrackingSystemDisabled
	category:~ASSETTRACKINGSYSTEMDISABLED_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMDISABLED_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMDISABLED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.disabled = not ATSOps.disabled )
		Catch() 
	)

	on isChecked return ATSOps.disabled
	on isEnabled return (ATSOps.NumProviders() > 0)
)

macroScript AssetTrackingSystemAutoLogin
	category:~ASSETTRACKINGSYSTEMAUTOLOGIN_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMAUTOLOGIN_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMAUTOLOGIN_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.autologin = not ATSOps.autologin )
		Catch() 
	)

	on isChecked return ATSOps.autologin
	on isEnabled return (ATSOps.NumProviders() > 0)	
)

macroScript AssetTrackingSystemCheckNetworkPaths
	category:~ASSETTRACKINGSYSTEMCHECKNETWORKPATHS_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMCHECKNETWORKPATHS_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMCHECKNETWORKPATHS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.checkNetworkPaths = not ATSOps.checkNetworkPaths )
		Catch() 
	)

	on isChecked return ATSOps.checkNetworkPaths	
)

macroScript AssetTrackingSystemTreeView
	category:~ASSETTRACKINGSYSTEMTREEVIEW_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMTREEVIEW_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMTREEVIEW_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.treeview = not ATSOps.treeview )
		Catch() 
	)

	on isChecked return ATSOps.treeview
)

macroScript AssetTrackingSystemTableView
	category:~ASSETTRACKINGSYSTEMTABLEVIEW_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMTABLEVIEW_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMTABLEVIEW_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.tableview = not ATSOps.tableview )
		Catch() 
	)

	on isChecked return ATSOps.tableview
)

macroScript AssetTrackingSystemDisplayExcluded
	category:~ASSETTRACKINGSYSTEMDISPLAYEXCLUDED_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMDISPLAYEXCLUDED_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMDISPLAYEXCLUDED_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.DisplayExcluded = not ATSOps.DisplayExcluded )
		Catch() 
	)

	on isChecked return ATSOps.DisplayExcluded
	on isEnabled return (ATSOps.NumProviders() > 0)	
)

macroScript AssetTrackingSystemExcludeOutputFiles
	category:~ASSETTRACKINGSYSTEMEXCLUDEOUTPUTFILES_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMEXCLUDEOUTPUTFILES_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMEXCLUDEOUTPUTFILES_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.ExcludeOutputFiles = not ATSOps.ExcludeOutputFiles )
		Catch() 
	)

	on isChecked return ATSOps.ExcludeOutputFiles
	on isEnabled return (ATSOps.NumProviders() > 0)	
)

macroScript AssetTrackingSystemRefresh
	category:~ASSETTRACKINGSYSTEMREFRESH_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMREFRESH_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMREFRESH_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.Refresh() )
		Catch() 
	)

)

macroScript AssetTrackingSystemLogin
	category:~ASSETTRACKINGSYSTEMLOGIN_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMLOGIN_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMLOGIN_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.Login 0 )
		Catch() 
	)
	on isEnabled return ( (not ATSOps.IsInitialized 0) and (not ATSOps.Disabled) and (ATSOps.NumProviders() > 0))
)

macroScript AssetTrackingSystemLogout
	category:~ASSETTRACKINGSYSTEMLOGOUT_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMLOGOUT_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMLOGOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.Logout 0 )
		Catch() 
	)
	on isEnabled return (ATSOps.IsInitialized 0)
)

macroScript AssetTrackingSystemCheckin
	category:~ASSETTRACKINGSYSTEMCHECKIN_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMCHECKIN_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMCHECKIN_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			local comment = ""
			ATSOps.Checkin 0 filelist comment
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanCheckin()
)

macroScript AssetTrackingSystemCheckout
	category:~ASSETTRACKINGSYSTEMCHECKOUT_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMCHECKOUT_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMCHECKOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			local comment = ""
			ATSOps.Checkout 0 filelist comment
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanCheckout()
)

macroScript AssetTrackingSystemUndoCheckout
	category:~ASSETTRACKINGSYSTEMUNDOCHECKOUT_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMUNDOCHECKOUT_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMUNDOCHECKOUT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.UndoCheckout 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanUndoCheckout()
)

macroScript AssetTrackingSystemAddFile
	category:~ASSETTRACKINGSYSTEMADDFILE_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMADDFILE_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMADDFILE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(	
			local filelist = #() 
			local comment = ""
			ATSOps.AddFiles 0 filelist comment
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanAddFiles()
)

macroScript AssetTrackingSystemGetLatest
	category:~ASSETTRACKINGSYSTEMGETLATEST_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMGETLATEST_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMGETLATEST_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.GetLatest 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanGetLatest()
)

macroScript AssetTrackingSystemProperties
	category:~ASSETTRACKINGSYSTEMPROPERTIES_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMPROPERTIES_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMPROPERTIES_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.Properties 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanProperties()
)

macroScript AssetTrackingSystemHistory
	category:~ASSETTRACKINGSYSTEMHISTORY_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMHISTORY_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMHISTORY_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.ShowHistory 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanShowHistory()
)

macroScript AssetTrackingSystemOptions
	category:~ASSETTRACKINGSYSTEMOPTIONS_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMOPTIONS_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMOPTIONS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.LaunchOptions 0 )
		Catch() 
	)
	
	on isEnabled return (ATSOps.IsInitialized 0)
)

macroScript AssetTrackingSystemLaunchSCC
	category:~ASSETTRACKINGSYSTEMLAUNCHSCC_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMLAUNCHSCC_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMLAUNCHSCC_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.LaunchProvider 0 )
		Catch() 
	)
	
	on isEnabled return ((not ATSOps.Disabled) and (ATSOps.NumProviders() > 0))
)

macroScript AssetTrackingSystemWorkingComment
	category:~ASSETTRACKINGSYSTEMWORKINGCOMMENT_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMWORKINGCOMMENT_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMWORKINGCOMMENT_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.ShowWorkingCommentDialog() )
		Catch() 
	)
	
	on isEnabled return ((ATSOps.IsInitialized 0) and (ATSOps.IsProjectOpen 0))
)

macroScript AssetTrackingSystemPromptsDialog
	category:~ASSETTRACKINGSYSTEMPROMPTSDIALOG_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMPROMPTSDIALOG_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMPROMPTSDIALOG_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( ATSOps.ShowPromptsDialog() )
		Catch() 
	)
)

macroScript AssetTrackingSystemDViewImageFile
	category:~ASSETTRACKINGSYSTEMDVIEWIMAGEFILE_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMDVIEWIMAGEFILE_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMDVIEWIMAGEFILE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		myFileList = #()
		iCount = atsops.getSelectedFiles &myFileList
		if iCount > 0 then 
		(
			-- Use resolved file names
			myResolvedFileList = #()
			atsops.getResolvedPaths &myFileList &myResolvedFileList
			if (myResolvedFileList.count > 0) then
			(
				local bm = openBitmap myResolvedFileList[1]
				if (bm != undefined) then
				(
					display bm
				)
			)
		)
	)
	
	on isEnabled Do
	(
		local result = true
		if atsops.numFilesSelected() != 1 then
		(
			result = false
		)
		myFileList = #()
		atsops.getSelectedFiles &myFileList
		if (myFileList.count > 0) then
		(
			local canImportBitmap = maxops.canImportBitmap myFileList[1]
			if (not canImportBitmap) then
			(
				result = false
			)
		)
		result
	)
)

macroScript AssetTrackingSystemCustomDeps
	category:~ASSETTRACKINGSYSTEMCUSTOMDEPS_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMCUSTOMDEPS_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMCUSTOMDEPS_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try( 
			ATSCustomDepsOps.LaunchDialog() 
			if ATSOps.visible do ATSOps.Refresh()
		)
		Catch() 
	)
)

macroScript AssetTrackingSystemGetFromProvider
	category:~ASSETTRACKINGSYSTEMGETFROMPROVIDER_CATEGORY~ 
	internalCategory:"Asset Tracking System" 
	tooltip:~ASSETTRACKINGSYSTEMGETFROMPROVIDER_TOOLTIP~
	ButtonText:~ASSETTRACKINGSYSTEMGETFROMPROVIDER_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try(
			fl = #() 
			ATSOps.GetFromProvider 0 "All files (*.*)" "*.*" false true true &fl
			)
		Catch() 
	)
	
	on isEnabled return (ATSOps.CanGetFromProvider 0)
)

--***********************************************************************************************
-- BITMAP PROXIES
-- Version:  3ds Max 9
-- Author:   Michaelson Britt
-- Bitmap Proxy action items
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript BitmapProxies_GlobalSettings
	category:~BITMAPPROXIES_GLOBALSETTINGS_CATEGORY~
	internalCategory:"Asset Tracking System"
	toolTip:~BITMAPPROXIES_GLOBALSETTINGS_TOOLTIP~
	ButtonText:~BITMAPPROXIES_GLOBALSETTINGS_BUTTONTEXT~ 
(
	on execute do (
		local b = bitmapProxyMgr
		if (b!=undefined) do (
			b.ShowConfigDialog()
		)
		if (atsops != undefined) do (
			atsops.refresh()
		)

	)
	on isEnabled do (
		local b = bitmapProxyMgr
		b != undefined
	)
)--end macro

macroScript BitmapProxies_EnableProxySystem
	category:~BITMAPPROXIES_ENABLEPROXYSYSTEM_CATEGORY~
	internalCategory:"Asset Tracking System"
	toolTip:~BITMAPPROXIES_ENABLEPROXYSYSTEM_TOOLTIP~
	ButtonText:~BITMAPPROXIES_ENABLEPROXYSYSTEM_BUTTONTEXT~
(
	on execute do (
		local b = bitmapProxyMgr
		if (b!=undefined) do (
			local enable = b.globalProxyEnable
			b.globalProxyEnable = (not enable)  -- NOTE: proxies refreshed automatically
		)
		if (atsops != undefined) do (
			atsops.refresh()
		)

	)
	on isEnabled do (
		local b = bitmapProxyMgr
		b != undefined
	)
	on isChecked do (
		local b = bitmapProxyMgr
		local result = (b != undefined) and b.globalProxyEnable
		result
	)
)--end macro

macroScript BitmapPager_EnableBitmapPaging
	category:~BITMAPPAGER_ENABLEBITMAPPAGING_CATEGORY~
	internalCategory:"Asset Tracking System"
	toolTip:~BITMAPPAGER_ENABLEBITMAPPAGING_TOOLTIP~
	ButtonText:~BITMAPPAGER_ENABLEBITMAPPAGING_BUTTONTEXT~
(
	on execute do (
		local b = IBitmapPager
		if (b!=undefined) do (
			local enable = b.enabled
			b.enabled = (not enable)
		)
		if (atsops != undefined) do (
			atsops.refresh()
		)

	)
	on isEnabled do (
		local b = IBitmapPager
		b != undefined
	)
	on isChecked do (
		local b = IBitmapPager
		local result = (b != undefined) and b.enabled
		result
	)
)--end macro

